import {Meta} from '@storybook/react/types-6-0';

import {TStorybookFunctionComponent} from 'storybook/types';

import {CurrencyType} from 'utilities/currency/CurrencyType';

import OrderHotelsDeferredPayment from './OrderHotelsDeferredPayment';

export default {
    title: 'Account/OrderHotelsDeferredPayment',
    component: OrderHotelsDeferredPayment,
} as Meta;

export const Simple: TStorybookFunctionComponent = () => (
    <OrderHotelsDeferredPayment
        totalPrice={{
            value: 28800,
            currency: CurrencyType.RUB,
        }}
        payment={{
            next: {
                amount: {
                    value: 28800,
                    currency: CurrencyType.RUB,
                },
                paymentEndsAt: '2022-07-19T20:59:00Z',
                penaltyIfUnpaid: {
                    value: 0,
                    currency: CurrencyType.RUB,
                },
            },
            receipts: [],
            amountPaid: {
                value: 0,
                currency: CurrencyType.RUB,
            },
            mayBeStarted: true,
            mayBeCancelled: false,
            usesDeferredPayments: true,
            usesZeroFirstPayment: true,
        }}
        orderId="02bd53bd-800f-45ca-a506-084e6aeaf873"
    />
);

Simple.parameters = {
    info: {
        title: 'Информация о доплате в заказе в ЛК',
    },
};
