import React from 'react';

import {IWithClassName} from 'types/withClassName';

import {useDeviceType} from 'utilities/hooks/useDeviceType';

import * as i18nBlock from 'i18n/account-OrderContacts';

import Flex from 'components/Flex/Flex';
import Text from 'components/Text/Text';

interface IOrderHotelsEmailProps extends IWithClassName {
    email: string;
}

const OrderHotelsEmail: React.FC<IOrderHotelsEmailProps> = props => {
    const {className, email} = props;

    const deviceType = useDeviceType();

    return (
        <Flex
            className={className}
            flexDirection={deviceType.isMobile ? 'column' : 'row'}
            inline={deviceType.isDesktop}
            between={deviceType.isDesktop ? 1 : undefined}
        >
            <Text>{i18nBlock.emailConfirmation()}</Text>
            <Text weight="bold">{email}</Text>
        </Flex>
    );
};

export default OrderHotelsEmail;
