import {Meta} from '@storybook/react/types-6-0';

import {
    CANCELLED_WITH_REFUND,
    FAILED,
    REFUND_FAILED,
} from 'projects/hotels/constants/hotelsBookingStatuses';

import {TStorybookFunctionComponent} from 'storybook/types';

import OrderHotelsError from './OrderHotelsError';

export default {
    title: 'Account/OrderHotelsError',
    component: OrderHotelsError,
} as Meta;

const yandexOrderId = 'YA-3359-1815-0851';

export const RefundFailed: TStorybookFunctionComponent = () => (
    <OrderHotelsError yandexOrderId={yandexOrderId} status={REFUND_FAILED} />
);

export const Failed: TStorybookFunctionComponent = () => (
    <OrderHotelsError yandexOrderId={yandexOrderId} status={FAILED} />
);

export const CancelledWithRefund: TStorybookFunctionComponent = () => (
    <OrderHotelsError
        yandexOrderId={yandexOrderId}
        status={CANCELLED_WITH_REFUND}
    />
);
