import React from 'react';

import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';
import {useDeviceType} from 'utilities/hooks/useDeviceType';
import {insertJSXIntoKey} from 'utilities/tanker/insertJSXIntoKey';

import * as i18nBlock from 'i18n/account-OrderHotels-Error';

import Flex from 'components/Flex/Flex';
import Heading from 'components/Heading/Heading';
import Text from 'components/Text/Text';
import SupportPhone from 'components/SupportPhone/SupportPhone';

interface IBaseErrorProps extends IWithQaAttributes {
    yandexOrderId: string;
    title: string;
    description: string;
    supportContactTitle?: string;
    action?: string;
}

const BaseError: React.FC<IBaseErrorProps> = props => {
    const {
        yandexOrderId,
        title,
        description,
        supportContactTitle = i18nBlock.supportDotTitle(),
        action,
    } = props;
    const deviceType = useDeviceType();

    return (
        <Flex flexDirection="column" between={deviceType.isMobile ? 3 : 4}>
            <Heading
                level={deviceType.isMobile ? '3' : '2'}
                {...prepareQaAttributes({parent: props, current: 'title'})}
            >
                {title}
            </Heading>
            <Flex flexDirection="column" between={3}>
                <div>{description}</div>
                <div>
                    <div>{supportContactTitle}</div>
                    <div>
                        {insertJSXIntoKey(i18nBlock.supportDotFirst)({
                            phone: (
                                <Text whiteSpace="nowrap" weight="bold">
                                    <SupportPhone />
                                </Text>
                            ),
                        })}
                    </div>
                    <div>
                        {insertJSXIntoKey(i18nBlock.supportDotSecond)({
                            orderId: (
                                <Text
                                    whiteSpace="nowrap"
                                    weight="bold"
                                    {...prepareQaAttributes({
                                        parent: props,
                                        current: 'orderId',
                                    })}
                                >
                                    {yandexOrderId}
                                </Text>
                            ),
                        })}
                    </div>
                </div>
                {action && <div>{action}</div>}
            </Flex>
        </Flex>
    );
};

export default BaseError;
