import React, {useMemo} from 'react';

import {IHotelGuest} from 'server/api/HotelsBookAPI/types/IOrder';
import {IWithClassName} from 'types/withClassName';

import {deviceMods} from 'utilities/stylesUtils';
import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';
import {useDeviceType} from 'utilities/hooks/useDeviceType';
import filterGuests from 'projects/account/pages/Order/components/OrderHotels/components/OrderHotelsGuests/utilities/filterGuests';

import * as i18nBlock from 'i18n/account-OrderHotels-Guests';

import Heading from 'components/Heading/Heading';
import Separator from 'components/Separator/Separator';
import CardWithDeviceLayout from 'components/CardWithDeviceLayout/CardWithDeviceLayout';
import Flex from 'components/Flex/Flex';
import OrderHotelGuest from 'projects/account/pages/Order/components/OrderHotels/components/OrderHotelsGuests/components/OrderHotelGuest/OrderHotelGuest';

import cx from './OrderHotelsGuests.scss';

interface IOrderHotelsGuests extends IWithClassName, IWithQaAttributes {
    guests: IHotelGuest[];
    inactive: boolean;
}

const OrderHotelsGuests: React.FC<IOrderHotelsGuests> = props => {
    const {className, guests, inactive} = props;

    const deviceType = useDeviceType();

    const filteredGuests = useMemo(() => filterGuests(guests), [guests]);

    return (
        <CardWithDeviceLayout
            className={cx(className, 'root', deviceMods('root', deviceType), {
                root_inactive: inactive,
            })}
            shadow={deviceType.isDesktop ? 'default' : 'none'}
            {...prepareQaAttributes(props)}
        >
            <Heading
                className={cx('title')}
                level={2}
                {...prepareQaAttributes({parent: props, current: 'title'})}
            >
                {i18nBlock.title()}
            </Heading>
            {deviceType.isDesktop && <Separator margin={8} />}
            <Flex className={cx('guests')} flexDirection="column" between={3}>
                {filteredGuests.map((guest: IHotelGuest, index: number) => (
                    <OrderHotelGuest
                        key={index}
                        guest={guest}
                        isMain={index === 0}
                        {...prepareQaAttributes({
                            parent: props,
                            current: 'guest',
                            key: index,
                        })}
                    />
                ))}
            </Flex>
        </CardWithDeviceLayout>
    );
};

export default React.memo(OrderHotelsGuests);
