import React from 'react';

import {IHotelGuest} from 'server/api/HotelsBookAPI/types/IOrder';

import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';

import * as i18nBlock from 'i18n/account-OrderHotels-Guests';

import Text from 'components/Text/Text';
import Flex from 'components/Flex/Flex';

interface IOrderHotelGuestProps extends IWithQaAttributes {
    guest: IHotelGuest;
    isMain: boolean;
}

const OrderHotelGuest: React.FC<IOrderHotelGuestProps> = props => {
    const {guest, isMain} = props;

    return (
        <Flex flexDirection="column" {...prepareQaAttributes(props)}>
            <Text
                {...prepareQaAttributes({
                    current: 'name',
                    parent: props,
                })}
            >
                {i18nBlock.name(guest)}
            </Text>
            {isMain && (
                <Text
                    weight="bold"
                    {...prepareQaAttributes({
                        current: 'isMain',
                        parent: props,
                    })}
                >
                    {i18nBlock.mainGuest()}
                </Text>
            )}
        </Flex>
    );
};

export default OrderHotelGuest;
