import {IHotelGuest} from 'server/api/HotelsBookAPI/types/IOrder';

export default function filterGuests(guests: IHotelGuest[]): IHotelGuest[] {
    return guests
        .filter(g => g.firstName || g.lastName)
        .map(({firstName, lastName}) => ({
            firstName: firstName || '',
            lastName: lastName || '',
        }));
}
