import {Meta} from '@storybook/react/types-6-0';

import {TStorybookFunctionComponent} from 'storybook/types';
import {IBookOfferRoom} from 'server/api/HotelsBookAPI/types/IBookOffer';

import OrderHotelsInfo from './OrderHotelsInfo';

export default {
    title: 'Account/OrderHotelsInfo',
    component: OrderHotelsInfo,
} as Meta;

const roomInfo: IBookOfferRoom = {
    name: "Люкс VIP [121631] 'Лучшая цена дня'",
    images: [
        {
            links: {
                '350px': {
                    href: 'https://www.travelline.ru/resource/images/rt/50728/636833311951207345-17a25b7a-c152-4e0c-8780-cf7917968017',
                },
            },
        },
        {
            links: {
                '350px': {
                    href: 'https://www.travelline.ru/resource/images/rt/50728/636833311950286081-2c864e50-9aec-452b-9fb4-ba65a634b855',
                },
            },
        },
        {
            links: {
                '350px': {
                    href: 'https://www.travelline.ru/resource/images/rt/50728/636833311940793770-1282f933-7c64-4c59-9ea4-4336e60c1f0e',
                },
            },
        },
        {
            links: {
                '350px': {
                    href: 'https://www.travelline.ru/resource/images/rt/50728/636833311941926362-aa29b176-3c15-498e-ace5-0f8686fdbb2e',
                },
            },
        },
        {
            links: {
                '350px': {
                    href: 'https://www.travelline.ru/resource/images/rt/50728/636833311949687437-2e68d85f-019a-474d-a354-4e87c561d94f',
                },
            },
        },
        {
            links: {
                '350px': {
                    href: 'https://www.travelline.ru/resource/images/rt/50728/636833311955266096-156ec192-9497-4e39-9120-18a2f1c216b9',
                },
            },
        },
    ],
    amenities: {
        '0': {
            id: 0,
            name: 'телефон',
        },
        '1': {
            id: 1,
            name: 'Wi-Fi',
        },
        '2': {
            id: 2,
            name: 'ванная комната',
        },
        '3': {
            id: 3,
            name: 'раковина',
        },
        '4': {
            id: 4,
            name: 'тапочки',
        },
        '5': {
            id: 5,
            name: 'халаты',
        },
        '6': {
            id: 6,
            name: 'банные полотенца',
        },
        '7': {
            id: 7,
            name: 'банные принадлежности',
        },
        '8': {
            id: 8,
            name: 'электронные замки',
        },
        '9': {
            id: 9,
            name: 'фен',
        },
        '10': {
            id: 10,
            name: 'весы',
        },
        '11': {
            id: 11,
            name: 'настольные лампы',
        },
        '12': {
            id: 12,
            name: 'холодильник',
        },
        '13': {
            id: 13,
            name: 'кровать «King size»',
        },
        '14': {
            id: 14,
            name: 'стулья',
        },
        '15': {
            id: 15,
            name: 'диван',
        },
        '16': {
            id: 16,
            name: 'гардеробная',
        },
        '17': {
            id: 17,
            name: 'зеркало',
        },
        '18': {
            id: 18,
            name: 'кресла',
        },
        '19': {
            id: 19,
            name: 'мягкая мебель',
        },
        '20': {
            id: 20,
            name: 'журнальный столик',
        },
        '21': {
            id: 21,
            name: 'шкаф для одежды',
        },
        '22': {
            id: 22,
            name: 'ковровое покрытие',
        },
        '23': {
            id: 23,
            name: 'информационная карта, меню',
        },
        '24': {
            id: 24,
            name: 'сейф',
        },
        '25': {
            id: 25,
            name: 'обслуживание номеров',
        },
        '26': {
            id: 26,
            name: 'письменные принадлежности',
        },
        '27': {
            id: 27,
            name: 'телевизор со Smart TV',
        },
        '28': {
            id: 28,
            name: 'утюг',
        },
        '29': {
            id: 29,
            name: 'телевизор с плоским экраном',
        },
        '30': {
            id: 30,
            name: 'usb порт',
        },
        '31': {
            id: 31,
            name: 'мини-холодильник',
        },
        '32': {
            id: 32,
            name: 'кондиционер',
        },
        '33': {
            id: 33,
            name: 'будильник',
        },
        '34': {
            id: 34,
            name: 'косметические средства',
        },
        '35': {
            id: 35,
            name: 'гигиенические средства',
        },
        '36': {
            id: 36,
            name: 'ванная с джакузи',
        },
        '37': {
            id: 37,
            name: 'вид на город',
        },
        '38': {
            id: 38,
            name: 'ортопедический матрас',
        },
        '39': {
            id: 39,
            name: 'вешалки',
        },
        '40': {
            id: 40,
            name: 'туалетный столик',
        },
        '41': {
            id: 41,
            name: 'эксклюзивная мебель',
        },
        '42': {
            id: 42,
            name: 'стул',
        },
        '43': {
            id: 43,
            name: 'шкаф-купе',
        },
        '44': {
            id: 44,
            name: 'туалетный столик',
        },
        '45': {
            id: 45,
            name: 'питьевая вода',
        },
        '46': {
            id: 46,
            name: 'стаканы',
        },
        '47': {
            id: 47,
            name: 'ковер',
        },
        '48': {
            id: 48,
            name: 'гостиная зона',
        },
        '49': {
            id: 49,
            name: 'косметическое зеркало',
        },
        '50': {
            id: 50,
            name: 'санузел',
        },
    },
    descriptions: {
        overview:
            '<p>Просторный номер с джакузи и барной стойкой, выполненный в классическом стиле располагаются на отдельном этаже с собственной входной группой, что обеспечивает приватность и быстрый беспрепятственный доступ. Отдельная lounge зона с чаем, кофе и бутилированной водой, а также профессиональный консьерж-сервис являются неотъемлемой частью номеров категории Люкс.</p><p>Беспроигрышный вариант, если вы хотите эффектно провести время, погрузившись в атмосферу роскоши.</p><p>Одна большая кровать 200 х 200.</p><p>Расположение: 4 этаж.</p><p>• VIP-размещение <br/>• Lounge зона с неограниченным доступом к чайно-кофейной станции<br/>• Изысканный завтрак в номер по специальному меню (по запросу, платная услуга)<br/>• LCD – телевизор с функцией SMART-TV (приветственный экран, прогноз погоды, просмотр фотографий, просмотр меню, просмотр счета и доступ в интернет-браузер)<br/>• Док-станция с функцией подзарядки мобильных устройств на Android и iOS и воспроизведения музыки, а так же smart - часы, помогающие соблюдать режим сна.<br/>• Ванна с гидромассажем<br/>• Душ<br/>• Халаты в номере<br/>• Косметика в ванной комнате бренда Hotel collection<br/>• Гладильная доска в номере <br/>• Бесплатный беспроводной интернет Wi-Fi <br/>• Бесплатное посещение фитнес-центра<br/>• Бесплатная чистка обуви<br/>• Услуги прачечной и химчистки по запросу <br/>• Заказ еды и напитков в номер по меню "Рум-сервис" круглосуточно</p>',
    },
};

export const Simple: TStorybookFunctionComponent = () => (
    <OrderHotelsInfo
        settlementInfo={{
            instructions: '',
            optionalCharge: '',
            mandatoryCharge:
                '<p>В стоимость включены следующие услуги:<ul><li><p><b>Приветственный напиток</b><br/>Приветственный напиток–шампанское или  лимонад доступен для вас по вашему желанию в зоне VIP регистрации.</p></li><li><p><b>VIP регистрация</b><br/>Воспользуйтесь услугой VIP регистрации : расположитесь в удобном кресле, предоставьте необходимые документы, а персональный менеджер по работе с гостями<br/>с радостью осуществит регистрацию.</p></li><li><p><b>Business access</b><br/>Воспользуйтесь рабочим пространством с бесплатным интернетом и возможностью работы с документами (печать, сканирование, копирование).</p></li></ul></p>',
            policyCheckinInfo: '',
            specialInstructions: '',
        }}
        roomInfo={roomInfo}
        bedsGroups={[
            {
                id: '0',
                description: 'кровать «King size»',
            },
        ]}
        mealInfo={{
            id: 'PT_RO',
            name: 'Без питания',
        }}
        inactive={false}
    />
);

Simple.parameters = {
    info: {
        title: 'Информация о комнате в отеле из заказа',
    },
};
