import React from 'react';

import {IWithClassName} from 'types/withClassName';

import {useDeviceType} from 'utilities/hooks/useDeviceType';

import * as i18nBlock from 'i18n/account-OrdersSearch';

import Flex from 'components/Flex/Flex';
import Text from 'components/Text/Text';

interface IOrderHotelsOrderIdProps extends IWithClassName {
    prettyOrderId: string;
}

const OrderHotelsOrderId: React.FC<IOrderHotelsOrderIdProps> = props => {
    const {className, prettyOrderId} = props;

    const deviceType = useDeviceType();

    return (
        <Flex
            className={className}
            flexDirection={deviceType.isMobile ? 'column' : 'row'}
            inline={deviceType.isDesktop}
            between={deviceType.isDesktop ? 1 : undefined}
        >
            <Text>{i18nBlock.prettyOrderIdDotLabel()}</Text>
            <Text>{prettyOrderId}</Text>
        </Flex>
    );
};

export default OrderHotelsOrderId;
