import {Meta} from '@storybook/react/types-6-0';
import moment from 'moment';

import {TStorybookFunctionComponent} from 'storybook/types';
import EBookOfferRefundableType from 'projects/account/pages/Order/types/EBookOfferRefundableType';

import {CurrencyType} from 'utilities/currency/CurrencyType';

import OrderHotelsRefundInfo from './OrderHotelsRefundInfo';

export default {
    title: 'Account/OrderHotelsRefundInfo',
    component: OrderHotelsRefundInfo,
} as Meta;

const start = moment().add(-10, 'day');

export const Simple: TStorybookFunctionComponent = () => (
    <OrderHotelsRefundInfo
        refundableInfo={{}}
        cancellationInfoAll={{
            refundable: true,
            refundableRules: [
                EBookOfferRefundableType.NO_PENALTY,
                EBookOfferRefundableType.SOME_PENALTY,
                EBookOfferRefundableType.SOME_PENALTY,
                EBookOfferRefundableType.FULL_PRICE,
            ].map((type, index) => {
                return {
                    price: {
                        amount: `${1234 * index}`,
                        currency: CurrencyType.RUB,
                    },
                    type,
                    endDate: start
                        .clone()
                        .add(10 * (index + 1), 'day')
                        .toISOString(),
                    startDate: start
                        .clone()
                        .add(10 * index, 'day')
                        .toISOString(),
                };
            }),
            highlighted: true,
        }}
    />
);

Simple.parameters = {
    info: {
        title: 'Градусник с информацией о возврате отеля',
    },
};

export const NonRefundable: TStorybookFunctionComponent = () => (
    <OrderHotelsRefundInfo
        refundableInfo={{}}
        cancellationInfoAll={{
            refundable: true,
            refundableRules: [],
            highlighted: true,
        }}
    />
);

NonRefundable.parameters = {
    info: {
        title: 'Отменить нельзя',
    },
};
