import React from 'react';

import {IBookOfferRefundableRuleAll} from 'projects/account/pages/Order/types/OrderHotelsCancellationProps';
import EBookOfferRefundableType from 'projects/account/pages/Order/types/EBookOfferRefundableType';

import {insertJSXIntoKey} from 'utilities/tanker/insertJSXIntoKey';
import {formatDate} from 'utilities/dateUtils';
import {HUMAN} from 'utilities/dateUtils/formats';

import * as i18nBlock from 'i18n/account-OrderHotels-RefundInfo';

import Price from 'components/Price/Price';

export default function getHeadingText(
    penalty?: IBookOfferRefundableRuleAll,
): React.ReactNode {
    if (!penalty) {
        return null;
    }

    switch (penalty.type) {
        case EBookOfferRefundableType.NO_PENALTY:
            return i18nBlock.titleDotNoPenalty();
        case EBookOfferRefundableType.FULL_PRICE:
            return i18nBlock.titleDotFullPrice();
        case EBookOfferRefundableType.SOME_PENALTY:
            return insertJSXIntoKey(i18nBlock.titleDotSomePenalty)({
                price: (
                    <Price
                        value={penalty.price.amount}
                        currency={penalty.price.currency}
                    />
                ),
                date: formatDate(penalty.endDate, HUMAN),
            });
        default:
            return null;
    }
}
