import React from 'react';

import {IBookOfferRefundableRuleAll} from 'projects/account/pages/Order/types/OrderHotelsCancellationProps';
import EBookOfferRefundableType from 'projects/account/pages/Order/types/EBookOfferRefundableType';

import {IDevice} from 'reducers/common/commonReducerTypes';

import {insertJSXIntoKey} from 'utilities/tanker/insertJSXIntoKey';

import * as i18nBlock from 'i18n/account-OrderHotels-RefundInfo';

import Price from 'components/Price/Price';

export default function getPenaltyText(
    refundableRule: IBookOfferRefundableRuleAll,
    deviceType: IDevice,
): React.ReactNode {
    const {type, price} = refundableRule;

    switch (type) {
        case EBookOfferRefundableType.SOME_PENALTY:
            return insertJSXIntoKey(i18nBlock.penaltyDotSomePenalty)({
                price: <Price value={price.amount} currency={price.currency} />,
            });

        case EBookOfferRefundableType.FULL_PRICE:
            return deviceType.isMobile
                ? i18nBlock.penaltyDotFullPriceDotMobile()
                : i18nBlock.penaltyDotFullPriceDotDesktop();

        case EBookOfferRefundableType.UNKNOWN:
            return null;

        default:
            return i18nBlock.penaltyDotNoPenalty();
    }
}
