import {IBookOfferCancellationInfoAll} from 'projects/account/pages/Order/types/OrderHotelsCancellationProps';
import EBookOfferRefundableType from 'projects/account/pages/Order/types/EBookOfferRefundableType';

import {formatDate} from 'utilities/dateUtils';
import {TIME} from 'utilities/dateUtils/formats';

import * as i18nBlock from 'i18n/account-OrderHotels-RefundInfo';

export default function getWarning(
    cancellationInfoAll: IBookOfferCancellationInfoAll,
): string | undefined {
    const {
        highlightNextType,
        highlightDaysLeft,
        highlightDate,
        highlightDateSame,
    } = cancellationInfoAll;

    if (Number(highlightDaysLeft) > 0) {
        const params = {
            days: highlightDaysLeft || 0,
        };

        switch (highlightNextType) {
            case EBookOfferRefundableType.SOME_PENALTY:
                return i18nBlock.warningDotPenaltyDotDays(params);
            case EBookOfferRefundableType.MORE_PENALTY:
                return i18nBlock.warningDotMoreDotDays(params);
            case EBookOfferRefundableType.FULL_PRICE:
                return i18nBlock.warningDotFullDotDays(params);
        }
    } else if (highlightDateSame) {
        const params = {
            time: highlightDate ? formatDate(highlightDate, TIME) : '',
        };

        switch (highlightNextType) {
            case EBookOfferRefundableType.SOME_PENALTY:
                return i18nBlock.warningDotPenaltyDotToday(params);
            case EBookOfferRefundableType.MORE_PENALTY:
                return i18nBlock.warningDotMoreDotToday(params);
            case EBookOfferRefundableType.FULL_PRICE:
                return i18nBlock.warningDotFullDotToday(params);
        }
    }

    const params = {
        time: highlightDate ? formatDate(highlightDate, TIME) : '',
    };

    switch (highlightNextType) {
        case EBookOfferRefundableType.SOME_PENALTY:
            return i18nBlock.warningDotPenaltyDotTomorrow(params);
        case EBookOfferRefundableType.MORE_PENALTY:
            return i18nBlock.warningDotMoreDotTomorrow(params);
        case EBookOfferRefundableType.FULL_PRICE:
            return i18nBlock.warningDotFullDotTomorrow(params);
    }
}
