import {Meta} from '@storybook/react/types-6-0';
import routerDecorator from 'storybook/storyDecorators/routerDecorator';

import {TStorybookFunctionComponent} from 'storybook/types';
import {EYandexPlusApplicationMode} from 'types/hotels/offer/IHotelOffer';

import {CurrencyType} from 'utilities/currency/CurrencyType';

import RefundDetails from './RefundDetails';

export default {
    title: 'Account/RefundDetails',
    component: RefundDetails,
    decorators: [routerDecorator],
} as Meta;

export const Simple: TStorybookFunctionComponent = () => (
    <RefundDetails
        appliedPromoCampaigns={{
            yandexPlus: {
                mode: EYandexPlusApplicationMode.TOPUP,
                points: 100,
            },
        }}
        amountPaid={{
            value: 1,
            currency: CurrencyType.RUB,
        }}
        totalPrice={{
            value: 10000,
            currency: CurrencyType.RUB,
        }}
        refund={{
            amount: 9000,
            currency: CurrencyType.RUB,
        }}
        penalty={{
            amount: 1000,
            currency: CurrencyType.RUB,
        }}
    />
);

Simple.parameters = {
    info: {
        title: 'Подробности возврата в отельном заказе',
    },
};
