import React from 'react';

import {
    EYandexPlusApplicationMode,
    IYandexPlusApplicationInfo,
} from 'types/hotels/offer/IHotelOffer';

import {insertJSXIntoKey} from 'utilities/tanker/insertJSXIntoKey';

import * as i18nBlock from 'i18n/account-OrderHotels-Price';

import Text from 'components/Text/Text';

interface IPlusRefundDescriptionProps {
    yandexPlus: IYandexPlusApplicationInfo | undefined;
}

const PlusRefundDescription: React.FC<IPlusRefundDescriptionProps> = props => {
    const {yandexPlus} = props;

    if (
        !yandexPlus ||
        yandexPlus.mode !== EYandexPlusApplicationMode.WITHDRAW ||
        yandexPlus.points === 0
    ) {
        return null;
    }

    return (
        <Text size="m">
            {insertJSXIntoKey(i18nBlock.refundPlusDescription)({
                plus: (
                    <Text size="inherit" color="plus" weight="bold">
                        {i18nBlock.refundPlusText()}
                    </Text>
                ),
            })}
        </Text>
    );
};

export default React.memo(PlusRefundDescription);
