import {MutableRefObject, useMemo, useRef} from 'react';

import EPopupDirection from 'components/Popup/types/EPopupDirection';

import {useBoolean} from 'utilities/hooks/useBoolean';
import {useDeviceType} from 'utilities/hooks/useDeviceType';

import {IActionsDialogProps} from 'components/ActionsDialog/ActionsDialog';

interface IResult {
    commonProps: Pick<
        IActionsDialogProps,
        | 'buttonRef'
        | 'iconSize'
        | 'popupDirections'
        | 'popupSecondaryOffset'
        | 'delayAfterSelect'
    >;
    isOpened: boolean;
    ref: MutableRefObject<null>;
    open(): void;
    close(): void;
}

export default function useActionsDialog(): IResult {
    const deviceType = useDeviceType();
    const ref = useRef(null);
    const {value, setTrue, setFalse} = useBoolean(false);

    const commonProps = useMemo(() => {
        return {
            buttonRef: ref,
            iconSize: 24 as const,
            popupDirections: [
                EPopupDirection.BOTTOM_LEFT,
                EPopupDirection.TOP_LEFT,
            ],
            popupSecondaryOffset: -24,
            delayAfterSelect: deviceType.isMobile ? 500 : undefined,
        };
    }, [deviceType.isMobile]);

    return {
        commonProps,
        ref,
        isOpened: value,
        open: setTrue,
        close: setFalse,
    };
}
