import {useMemo} from 'react';

import IActionItem from 'components/ActionsDialog/types/IActionItem';

import {useBoolean} from 'utilities/hooks/useBoolean';

import DetailsIcon from 'icons/24/Details';

interface IParams {
    title: string;
}

interface IResult {
    actions: IActionItem[];
    isVisible: boolean;
    close(): void;
}

export default function useDetailsActions({title}: IParams): IResult {
    const {value, setTrue, setFalse} = useBoolean(false);

    const actions = useMemo(() => {
        const action = {
            id: 'orderDetails',
            title: title,
            icon: DetailsIcon,
            onClick: setTrue,
        };

        return [action];
    }, [setTrue, title]);

    return {
        actions,
        isVisible: value,
        close: setFalse,
    };
}
