import {EFiscalReceiptType} from 'projects/hotels/constants/EFiscalReceiptType';

import ordinalsCount from 'utilities/plural/ordinalsCount';

import * as i18nBlock from 'i18n/account-OrderHotels-Price';

interface IParams {
    isSingle: boolean;
    type: EFiscalReceiptType;
    index: number;
}

export default function getFiscalReceiptText({
    isSingle,
    type,
    index,
}: IParams): string {
    const number = ordinalsCount(index + 1);

    switch (type) {
        case EFiscalReceiptType.ACQUIRE:
            return isSingle
                ? i18nBlock.receiptTitleSingle()
                : i18nBlock.receiptTitle({
                      number,
                  });
        case EFiscalReceiptType.CLEAR:
        case EFiscalReceiptType.REFUND:
            return isSingle
                ? i18nBlock.receiptRefundTitleSingle()
                : i18nBlock.receiptRefundTitle({
                      number,
                  });
    }
}
