import {IBookOffer} from 'server/api/HotelsBookAPI/types/IBookOffer';
import {EYandexPlusApplicationMode} from 'types/hotels/offer/IHotelOffer';

import {IOrderInfoReducer} from 'reducers/hotels/bookAndPayPage/orderInfo/reducer';

import IPrice from 'utilities/currency/PriceInterface';

import getTotalPrice from './getTotalPrice';

interface IParams {
    offerInfo: IBookOffer;
    orderInfo: IOrderInfoReducer;
}

interface IResult {
    amountPaid?: IPrice;
    totalPrice?: IPrice;
}

/**
 * Сastyl для кейса, когда в заказе были списаны баллы плюса
 *
 * Используется для отображения графы «Оплачено»:
 *  - на странице заказа
 *  - в модальном окне деталей заказа
 *  - в блоке рассрочки
 * Не используется
 *  - в модальном окне с информацией о возврат, так как суммы к возврату приходят тоже без учетов плюса, и есть предупреждение, что часть суммы вернется баллами
 *  - в блоке с информацией о рассрочке, так как рассрочка и списание баллов не могут быть одновременно
 *
 * Мы берем количество уплаченных денег и стоимость заказа из офера priceAfterPlusWithdraw,
 * мы можем так сделать, так как рассрочка при списании баллов плюса невозможна
 * @link https://st.yandex-team.ru/TRAVELBACK-3875
 */
export default function getAmountPaidAndTotalPriceAfterPlusWithdraw({
    offerInfo,
    orderInfo,
}: IParams): IResult {
    const {orderPriceInfo} = orderInfo;
    const {priceInfo} = offerInfo;

    const totalPrice = getTotalPrice({
        orderPriceInfo,
        priceInfo,
    });

    if (
        orderInfo.appliedPromoCampaigns?.yandexPlus?.mode ===
        EYandexPlusApplicationMode.WITHDRAW
    ) {
        const priceAfterPlusWithdraw =
            offerInfo.priceInfo.hotelCharges.totals?.priceAfterPlusWithdraw ||
            totalPrice;

        return {
            amountPaid: priceAfterPlusWithdraw,
            totalPrice: priceAfterPlusWithdraw,
        };
    }

    return {
        amountPaid: orderInfo.payment?.amountPaid,
        totalPrice,
    };
}
