import {
    IBookOfferPriceInfo,
    IBookOfferTaxesAndFeesCharges,
} from 'server/api/HotelsBookAPI/types/IBookOffer';

export default function getTaxesAndFeesSum(
    priceInfo: IBookOfferPriceInfo,
): IBookOfferTaxesAndFeesCharges | undefined {
    const hotelCharges = priceInfo?.hotelCharges;
    const sum = hotelCharges?.totals?.taxesAndFeesSum;

    if (
        sum &&
        'currency' in sum &&
        'amount' in sum &&
        sum.currency &&
        sum.amount
    ) {
        return sum;
    }

    return;
}
