import {IBookOfferPriceInfo} from 'server/api/HotelsBookAPI/types/IBookOffer';
import {IOrderPriceInfo} from 'server/api/HotelsBookAPI/types/IOrder';
import {offerPriceToPrice} from 'types/common/price/offerPriceToPrice';

import IPrice from 'utilities/currency/PriceInterface';

interface IGetTotalPriceParams {
    priceInfo: IBookOfferPriceInfo;
    orderPriceInfo: IOrderPriceInfo | null | undefined;
}

export default function getTotalPrice({
    orderPriceInfo,
    priceInfo,
}: IGetTotalPriceParams): IPrice | undefined {
    if (orderPriceInfo?.price) {
        return orderPriceInfo?.price;
    }

    const totalPrice = priceInfo?.hotelCharges?.totals?.totalPrice;

    if (!totalPrice) {
        return undefined;
    }

    return offerPriceToPrice(totalPrice);
}
