import React from 'react';

import {IWithClassName} from 'types/withClassName';

import {useDeviceType} from 'utilities/hooks/useDeviceType';
import {deviceMods} from 'utilities/stylesUtils';
import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';

import cx from './OrderWrapper.scss';

interface IOrderWrapperProps extends IWithClassName, IWithQaAttributes {}

const OrderWrapper: React.FC<IOrderWrapperProps> = props => {
    const {className, children} = props;

    const deviceType = useDeviceType();

    return (
        <div
            className={cx(className, 'root', deviceMods('root', deviceType))}
            {...prepareQaAttributes(props)}
        >
            {children}
        </div>
    );
};

export default OrderWrapper;
