import React, {useCallback, useEffect} from 'react';
import {useDispatch, useSelector} from 'react-redux';

import {ETrainsGoal} from 'utilities/metrika/types/goals/trains';
import {EAuthorizationOrderType} from 'server/api/OrdersAPI/types/IOrderAuthorization';
import {ORDER_TYPE_VALUES} from 'projects/account/lib/orders/types';

import * as actions from 'reducers/account/orders/actions';

import orderTrainsContainerSelector from 'projects/account/pages/Order/containers/OrderTrainsContainer/selectors/orderTrainsContainerSelector';

import {reachGoal} from 'utilities/metrika';
import {prepareQaAttributes} from 'utilities/qaAttributes/qaAttributes';

import * as i18nBlock from 'i18n/account-Order';

import BookLoader from 'components/BookLoader/BookLoader';
import GenericOrderTrains from 'projects/account/pages/Order/components/GenericOrderTrains/GenericOrderTrains';

export interface IOrderTrainsContainerProps {
    orderId: string;
    orderType: EAuthorizationOrderType.TRAIN | EAuthorizationOrderType.GENERIC;
}

const OrderTrainsContainer: React.FC<IOrderTrainsContainerProps> = props => {
    const {orderId, orderType} = props;

    const {isFetching} = useSelector(orderTrainsContainerSelector);

    const dispatch = useDispatch();
    const updateOrder = useCallback(
        (params: actions.IUpdateOrderParams) => {
            dispatch(actions.updateOrder.request(params));
        },
        [dispatch],
    );

    useEffect(() => {
        if (orderType === EAuthorizationOrderType.TRAIN) {
            updateOrder({orderId, trainsOrderType: ORDER_TYPE_VALUES.TRAINS});
        }

        reachGoal(ETrainsGoal.ORDER_INFO_PAGE_LOADED);
    }, [orderId, orderType, updateOrder]);

    if (isFetching && orderType === EAuthorizationOrderType.TRAIN) {
        return (
            <BookLoader
                title={i18nBlock.loaderDotTitle()}
                description={i18nBlock.loaderDotDescription()}
                isLoading
            />
        );
    }

    return <GenericOrderTrains {...prepareQaAttributes('genericOrderPage')} />;
};

export default React.memo(OrderTrainsContainer);
