enum EBookOfferRefundableType {
    NO_PENALTY = 'NO_PENALTY',
    SOME_PENALTY = 'SOME_PENALTY',
    FULL_PRICE = 'FULL_PRICE',
    MORE_PENALTY = 'MORE_PENALTY', // Эта штука нужна для отдельного случая повышения штрафа (не приходит от бекенда)
    UNKNOWN = 'UNKNOWN', // На случай, если приходит что-то неадекватное
}

export default EBookOfferRefundableType;

export function isBookOfferRefundableType(
    candidate: unknown,
): candidate is EBookOfferRefundableType {
    return Object.values(EBookOfferRefundableType).some(v => v === candidate);
}
