import {Moment} from 'moment';

import {IBookOfferPrice} from 'server/api/HotelsBookAPI/types/IBookOffer';

import EBookOfferRefundableType from './EBookOfferRefundableType';

export interface IBookOfferRefundableRuleAll {
    current: boolean;
    past: boolean;
    price: IBookOfferPrice;
    type: EBookOfferRefundableType;
    endDate: Moment;
    startDate: Moment;
}

export interface IBookOfferCancellationInfoAll {
    highlighted: boolean;
    refundable: boolean;
    hasTimeline: boolean;
    refundableRules: IBookOfferRefundableRuleAll[];
    currentPenalty?: IBookOfferRefundableRuleAll;
    refundedDate?: Moment;
    highlightDaysLeft?: number;
    highlightDate?: Moment;
    highlightNextType?: EBookOfferRefundableType;
    highlightDateSame?: boolean;
}
