import ITrainsDownloadBlankApiParams from 'server/api/TrainsBookingApi/types/ITrainsDownloadBlankApiParams';
import {ORDER_TYPE_VALUES} from 'projects/account/lib/orders/types';

import {internalUrl} from 'utilities/url';

/**
 * Формирует ссылку на скачивание билета или КРС (квитанция разных сборов)
 * в зависимости от переданных параметров
 */
export default function getDownloadBlankUrl(
    params: ITrainsDownloadBlankApiParams,
    trainsOrderType:
        | ORDER_TYPE_VALUES.TRAINS
        | ORDER_TYPE_VALUES.TRAINS_GENERIC
        | null,
): string {
    const path =
        trainsOrderType === ORDER_TYPE_VALUES.TRAINS
            ? 'api/trains/downloadBlankFromTrainApi'
            : 'api/trains/downloadBlank';

    return internalUrl(path, params);
}
