import {IRefundPartInfo} from 'server/api/GenericOrderApi/types/common/refund/IRefundPartInfo';
import {ORDER_TYPE_VALUES} from 'projects/account/lib/orders/types';
import ERefundType from 'server/api/GenericOrderApi/types/common/refund/ERefundType';

import getGenericDownloadBlankUrl from 'projects/account/pages/Order/utilities/downloadBlank/getGenericDownloadBlankUrl';
import getDownloadBlankUrl from 'projects/account/pages/Order/utilities/downloadBlank/getDownloadBlankUrl';

export default function getTicketRefundBlankUrl({
    orderId,
    blankId,
    orderType,
    refundPartInfo,
}: {
    orderId: string;
    blankId: string;
    orderType:
        | ORDER_TYPE_VALUES.TRAINS
        | ORDER_TYPE_VALUES.TRAINS_GENERIC
        | null;
    refundPartInfo: IRefundPartInfo | null;
}): string | null {
    const refundType = refundPartInfo?.refund?.type;
    const refundBlankToken = refundPartInfo?.refund?.refundBlankToken;

    if (refundType === ERefundType.TRAIN_OFFICE_REFUND) {
        return null;
    }

    if (refundBlankToken) {
        return getGenericDownloadBlankUrl({token: refundBlankToken, orderId});
    }

    return getDownloadBlankUrl({id: orderId, blankId}, orderType);
}
