import moment from 'moment';

import ITrainTicket from 'server/api/GenericOrderApi/types/common/service/ITrainServiceInfo/ITrainPassenger/ITrainTicket';

import {getIsRemoteCheckinEnabledForTicket} from 'projects/account/pages/Order/utilities/getIsRemoteCheckinEnabled';

/**
 * Можно ли изменить ЭР в тикете
 */
export default function getIsRemoteCheckinAllowedInTicket(
    ticket: ITrainTicket,
    timestamp: number,
): boolean {
    return (
        getIsRemoteCheckinEnabledForTicket(ticket) &&
        Boolean(
            ticket.canChangeElectronicRegistrationTill &&
                moment(timestamp).isBefore(
                    ticket.canChangeElectronicRegistrationTill,
                ),
        )
    );
}
