/**
 * TODO Перенести эту логику на бэкенд
 * Попросить бэкендеров сразу возвращать, есть ЭР или нет для билета или заказа
 * https://st.yandex-team.ru/TRAVELFRONT-3709
 */
import {IOrderTicket} from 'reducers/trains/order/types';
import {TrainsOrderInfoTicketRzhdStatus} from 'server/api/TrainsBookingApi/types/TrainsOrderInfoTicketRzhdStatus';
import ITrainTicket from 'server/api/GenericOrderApi/types/common/service/ITrainServiceInfo/ITrainPassenger/ITrainTicket';

/**
 * Определяет есть ли ЭР для билета
 * Договорился с ganintsev@, что такое условие поможет определить ЭР для всех случаев
 * https://st.yandex-team.ru/TRAVELFRONT-3635
 */
export function getIsRemoteCheckinEnabledForTicket(
    ticket: IOrderTicket | ITrainTicket,
): boolean {
    return (
        Boolean(ticket.canChangeElectronicRegistrationTill) ||
        ticket.rzhdStatus !== TrainsOrderInfoTicketRzhdStatus.NO_REMOTE_CHECK_IN
    );
}
