import moment from 'moment';

const DAYS_COUNT_AFTER_DEPARTURE_TO_BECOME_ARCHIVED = 10;

/**
 * Считаем заказ архивным после 10 дней,
 * до этого времени человек ещё может вернуть билет,
 * если болел или с ним случился несчастный случай
 * @link https://st.yandex-team.ru/TRAVELFRONT-747
 * @param departure - время отправления последнего поезда из заказа в UTC
 * @param timestamp - текущий момент времени в миллисекундах (Unix Timestamp)
 */
export default function isArchivedOrder(
    departure: string,
    timestamp: number,
): boolean {
    const departureMoment = moment(departure);
    const daysAfterDeparture = moment(timestamp).diff(
        departureMoment,
        'days',
        true,
    );

    return daysAfterDeparture >= DAYS_COUNT_AFTER_DEPARTURE_TO_BECOME_ARCHIVED;
}
