import * as i18nBlock from 'i18n/accountForms';

import {EDocumentType} from 'server/api/TravelersApi/enums/EDocumentType';

export default function getDocumentNameText(type: EDocumentType): string {
    switch (type) {
        case EDocumentType.RU_NATIONAL_PASSPORT:
            return i18nBlock.valuesDotTypeDotRuNationalPassport();
        case EDocumentType.RU_FOREIGN_PASSPORT:
            return i18nBlock.valuesDotTypeDotRuForeignPassport();
        case EDocumentType.RU_BIRTH_CERTIFICATE:
            return i18nBlock.valuesDotTypeDotRuBirthCertificate();
        case EDocumentType.RU_SEAMAN_PASSPORT:
            return i18nBlock.valuesDotTypeDotRuSeamanPassport();
        case EDocumentType.RU_MILITARY_ID:
            return i18nBlock.valuesDotTypeDotRuMilitaryId();
        case EDocumentType.OTHER:
            return i18nBlock.valuesDotTypeDotOther();
    }
}
