import React from 'react';

import {IWithClassName} from 'types/withClassName';

import {useMobile} from 'utilities/hooks/useMobile';
import {
    prepareQaAttributes,
    IWithQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';

import cx from './Meta.scss';

interface IMetaProps extends IWithClassName, IWithQaAttributes {
    name: string;
}

const Meta: React.FC<IMetaProps> = props => {
    const {name, className, children} = props;
    const isMobile = useMobile();

    return (
        <div
            className={cx('item', className, {
                item_mobile: isMobile,
            })}
        >
            <div className={cx('small')}>{name}</div>
            <div className={cx('value')} {...prepareQaAttributes(props)}>
                {children}
            </div>
        </div>
    );
};

export default Meta;
