import {PureComponent, ReactNode} from 'react';
import _noop from 'lodash/noop';

import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';

import LinkButton from 'components/LinkButton/LinkButton';
import EditIcon from 'icons/16/Edit';
import DeleteIcon from 'icons/16/Delete';

import cx from './PassengerActions.scss';

interface IPassengerActionsProps extends IWithQaAttributes {
    icon: string;
    onClick: () => void;
}

class PassengerActions extends PureComponent<IPassengerActionsProps> {
    static defaultProps = {
        onClick: _noop,
    };

    private renderIcon(): ReactNode {
        const {icon} = this.props;

        switch (icon) {
            case 'delete':
                return <DeleteIcon className={cx('icon', 'delete')} />;
            case 'edit':
                return <EditIcon className={cx('icon', 'edit')} />;
            default:
                return null;
        }
    }

    render(): ReactNode {
        const {onClick} = this.props;

        return (
            <LinkButton
                theme="ghost"
                onClick={onClick}
                {...prepareQaAttributes(this.props)}
            >
                {this.renderIcon()}
            </LinkButton>
        );
    }
}

export default PassengerActions;
