import React from 'react';

import {IInputProps} from 'components/Input/types/InputProps';

import {useMobile} from 'utilities/hooks/useMobile';

import Input from 'components/Input/Input';
import DateInput from 'components/DateInput/DateInput';
import {IMaskedInputProps} from 'components/MaskedInput/MaskedInput';

import cx from './PassengerFormInput.scss';

const PassengerInput: React.FC<IMaskedInputProps | IInputProps> = props => {
    const isMobile = useMobile();

    switch (props.type) {
        case 'date':
            return (
                <DateInput
                    {...props}
                    keepCharPositions={true}
                    className={cx('input', 'input_date', {
                        input_mobile: isMobile,
                    })}
                />
            );
        case 'text':
            return (
                <Input
                    {...props}
                    className={cx('input', {
                        input_mobile: isMobile,
                    })}
                />
            );
        default:
            return null;
    }
};

export default PassengerInput;
