import React, {PureComponent} from 'react';

import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';

import * as i18nBlock from 'i18n/account';

import Button from 'components/Button/Button';

import cx from './PassengerForms.scss';

interface IPassengerFormsProps extends IWithQaAttributes {
    handleSubmit: () => void;
    isMobile: boolean;
    onModalClose: () => void;
    title: string;
}

class PassengerForms extends PureComponent<IPassengerFormsProps> {
    renderCancelButton(): React.ReactNode {
        const {onModalClose, isMobile} = this.props;

        return (
            <div className={cx('control')}>
                <Button
                    width="max"
                    size={isMobile ? 'l' : 'm-inset'}
                    onClick={onModalClose}
                    className={cx('button')}
                >
                    {i18nBlock.commonDotCancel()}
                </Button>
            </div>
        );
    }

    renderSaveButton(): React.ReactNode {
        const {isMobile} = this.props;

        return (
            <div
                {...prepareQaAttributes({
                    parent: this.props,
                    current: 'submit',
                })}
                className={cx('control')}
            >
                <Button
                    theme="primary"
                    width="max"
                    size={isMobile ? 'l' : 'm-inset'}
                    type="submit"
                    className={cx('button')}
                >
                    {i18nBlock.commonDotSave()}
                </Button>
            </div>
        );
    }

    renderControls(): React.ReactNode {
        return (
            <div className={cx('buttons')}>
                {this.renderCancelButton()}
                {this.renderSaveButton()}
            </div>
        );
    }

    render(): React.ReactNode {
        const {handleSubmit, isMobile, title, children} = this.props;

        return (
            <form
                className={cx('form', {form_mobile: isMobile})}
                onSubmit={handleSubmit}
                noValidate
                {...prepareQaAttributes(this.props)}
            >
                <div className={cx('title')}>{title}</div>
                <div className={cx('block')}>{children}</div>
                {this.renderControls()}
            </form>
        );
    }
}

export default PassengerForms;
