import React from 'react';

import {prepareQaAttributes} from 'utilities/qaAttributes/qaAttributes';
import {deviceMods} from 'utilities/stylesUtils';
import {useDeviceType} from 'utilities/hooks/useDeviceType';

import * as i18nBlock from 'i18n/account';

import Button from 'components/Button/Button';
import PlusIcon from 'icons/16/Plus';

import cx from './PassengerListButtons.scss';

interface IPassengerListButtonsProps {
    onOpenAddModal: () => void;
}

const PassengerListButtons: React.FC<IPassengerListButtonsProps> = props => {
    const {onOpenAddModal} = props;

    const deviceType = useDeviceType();

    return (
        <div className={cx('root', deviceMods('root', deviceType))}>
            <div className={cx('block')}>
                <div
                    className={cx('button')}
                    {...prepareQaAttributes('passenger-list-add')}
                >
                    <Button
                        theme="primary"
                        size="m-inset"
                        width="max"
                        onClick={onOpenAddModal}
                        className={cx('wideButton')}
                        icon={<PlusIcon className={cx('icon')} />}
                    >
                        {i18nBlock.listDotAdd()}
                    </Button>
                </div>
            </div>
        </div>
    );
};

export default React.memo(PassengerListButtons);
