/* eslint-disable camelcase */
import {FocusEventHandler} from 'react';
import {FormRenderProps} from 'react-final-form';

import {ICountry} from 'types/common/ICountry';
import {IPassengerDocumentData} from 'types/common/document/IPassengerDocumentData';

import {IDocTypesProps} from 'reducers/account/docTypes/api-types';
import {IDevice} from 'reducers/common/commonReducerTypes';
import {IPreparedPassenger} from 'reducers/account/passengers/api-types';

import {DateLikeType} from 'utilities/dateUtils';

import {EDocumentType} from 'server/api/TravelersApi/enums/EDocumentType';

export interface IBuildFieldProps {
    name: string;
    type: string;
    size: string;
    small: boolean;
    documents: boolean;
}

export interface IErrorsProps {
    [name: string]: string;
}

export interface IAddFormValuesProps {
    birthDate: DateLikeType;
    expirationDate?: DateLikeType;
    type: EDocumentType | EDocumentType[];
    citizenship: number;
    firstName: string;
    lastName: string;
    middleName: string;
    firstNameEn?: string;
    lastNameEn?: string;
    middleNameEn?: string;
    gender: string;
    number: string;
    itn?: string;
    email?: string;
    phone?: string;
    train_notifications_enabled?: boolean;
}

export interface IEditFormValuesProps {
    birthDate?: DateLikeType;
    title?: string;
    gender?: string;
    itn?: string;
    email?: string;
    phone?: string;
    train_notifications_enabled?: boolean;
}

export interface IDocumentFormValuesProps {
    expirationDate?: DateLikeType;
    type: EDocumentType[] | EDocumentType;
    citizenship: number[] | number;
    firstName: string;
    lastName: string;
    middleName: string;
    firstNameEn?: string;
    lastNameEn?: string;
    middleNameEn?: string;
    number: string;
}

export interface IValidationResultProps {
    errors: IErrorsProps;
}

export interface IPassengerFormsDefaultProps {
    form: string;
    onModalClose: () => void;
    deviceType: IDevice;
    modalRef: HTMLElement | undefined | null;
    formErrors: IErrorsProps;
    getFieldRefByName: (e: string) => HTMLInputElement | null;
    setFieldRefByName: (
        e: string,
    ) => (element: HTMLInputElement | null) => void;
    onFocusField: FocusEventHandler<HTMLElement>;
    onBlurField: () => void;
    onTrySubmit: () => void;
    handleSubmit: FormRenderProps['handleSubmit'];
    canShowErrors: boolean;
    finalFormManager?: boolean;
}

export interface IAddPassengerFormProps extends IPassengerFormsDefaultProps {
    citizenship: ICountry[];
    docTypes: IDocTypesProps;
    formValues: IAddFormValuesProps;

    change: <F extends keyof IAddFormValuesProps>(
        name: F,
        value?: IAddFormValuesProps[F],
    ) => void;
}

export interface IPassengerFormsDefaultState {
    fields: IBuildFieldProps[];
}

export interface IPassengerEditFormProps extends IPassengerFormsDefaultProps {
    data: IPreparedPassenger;
    isVisible?: boolean;
    initialize(data: IPreparedPassenger): void;
    formValues: IPreparedPassenger;
}

export interface IDocumentEditFormProps extends IPassengerFormsDefaultProps {
    data?: Pick<IPassengerDocumentData, 'id' | 'passengerId' | 'type'>;
    citizenship: ICountry[];
    fields: IBuildFieldProps[];
    type?: EDocumentType;
    isVisible: boolean;
    docTypes: IDocTypesProps;
    initialize(data: IPassengerDocumentData): void;
    formValues: IPassengerDocumentData;
}

export interface IDocumentEditFormState {
    id: string;
    type?: EDocumentType;
    isVisible: boolean;
}
