import {FORM_FIELDS} from 'constants/account';

export default (fields: string[], extraOptions: Record<string, any> = {}) => {
    let currentSize = 0;

    return fields.map((item: string): any => {
        const value = {
            name: item,
            ...FORM_FIELDS[item],
            ...extraOptions[item],
        };

        currentSize += FORM_FIELDS[item].sizeParts;

        if (currentSize === 0.5 && FORM_FIELDS[item].size === 'small') {
            value.size = 'smallRight';
        }

        if (currentSize > 1) {
            currentSize = FORM_FIELDS[item].sizeParts;
        }

        return value;
    });
};
