import validateForm from './documentValidate';

const LATIN_REGEXP = /^[a-zA-Z '-]*$/;
const NAMES_FIELDS = ['firstName', 'lastName', 'middleName'];

export default ({rules, values, errors}: any) => {
    const fullName = `${values.firstName}${values.lastName}${values.middleName}`;
    const isLatinName = LATIN_REGEXP.test(fullName);

    NAMES_FIELDS.forEach(fieldName => {
        const fieldNameEn = `${fieldName}En`;

        if (errors[fieldName] || isLatinName) {
            if (
                !rules.required.includes(fieldName) &&
                !rules.unused.includes(fieldNameEn)
            ) {
                values[fieldNameEn] = values[fieldName];

                const errTemp: any = validateForm(values, rules);
                if (errTemp[fieldNameEn]) {
                    delete values[fieldNameEn];
                } else {
                    delete errors[fieldName];
                    delete values[fieldName];
                }
            }
        } else {
            delete values[fieldNameEn];
        }
    });

    return {
        values,
        errors,
    };
};
