import {IPassengerDocumentData} from 'types/common/document/IPassengerDocumentData';
import {IErrorsProps} from 'projects/account/pages/Passengers/types';

import {IDocTypesProps} from 'reducers/account/docTypes/api-types';

import {isDateInFuture, isValidDateForBackend} from 'utilities/dateUtils/index';
import {DOCUMENT_OTHER} from 'projects/account/lib/travellers/documents';

import * as i18nBlock from 'i18n/accountForms';

import {EDocumentType} from 'server/api/TravelersApi/enums/EDocumentType';

import validateForm from './documentValidate';

interface IValidationResultProps {
    errors: IErrorsProps;
}

export default (
    values: IPassengerDocumentData = {},
    docTypes: IDocTypesProps,
    type?: EDocumentType,
): IValidationResultProps => {
    let errors: IErrorsProps = {};

    if (type) {
        errors = validateForm(values, docTypes.rules[type]);

        if (type === DOCUMENT_OTHER && !values.citizenship) {
            errors.citizenship = i18nBlock.errorsDotRequiredDotCitizenship();
        }

        if (values.expirationDate) {
            if (!isValidDateForBackend(values.expirationDate)) {
                errors.expirationDate =
                    i18nBlock.errorsDotExpirationDateDotWrong();
            } else if (!isDateInFuture(values.expirationDate)) {
                errors.expirationDate =
                    i18nBlock.errorsDotExpirationDateDotPast();
            }
        }
    }

    return {errors};
};
