import {FORM_FIELDS} from 'constants/account';

import {IPassengerDocumentData} from 'types/common/document/IPassengerDocumentData';
import {IErrorsProps} from '../../types';

import {IDocTypesRule} from 'reducers/account/docTypes/api-types';

import {EDocumentType} from 'projects/account/lib/travellers/documents';
import getErrorsRequiredText from 'projects/account/pages/Passengers/utilities/validateForm/getErrorsRequiredText';
import getErrorsDocumentNumberText from 'projects/account/pages/Passengers/utilities/validateForm/getErrorsDocumentNumberText';
import getErrorsFieldText from 'projects/account/pages/Passengers/utilities/validateForm/getErrorsFieldText';

const validateForm = (
    values: IPassengerDocumentData,
    doc: IDocTypesRule,
): IErrorsProps => {
    const errors: IErrorsProps = {};
    const valueType =
        (Array.isArray(values.type) ? values.type[0] : values.type) ??
        EDocumentType.OTHER;

    Object.keys(FORM_FIELDS).forEach(field => {
        const value =
            values[
                field as keyof Omit<
                    IPassengerDocumentData,
                    'citizenship' | 'type' | 'expirationDate'
                >
            ];

        if (doc.required.includes(field)) {
            if (!value) {
                errors[field] = getErrorsRequiredText(field);
            } else if (
                Object.prototype.hasOwnProperty.call(doc.validation, field)
            ) {
                const reg = new RegExp(doc.validation[field]);

                if (!reg.test(value)) {
                    if (field === 'number') {
                        errors[field] = getErrorsDocumentNumberText(valueType);
                    } else {
                        errors[field] = getErrorsFieldText(field);
                    }
                }
            }
        } else if (
            Object.prototype.hasOwnProperty.call(doc.validation, field)
        ) {
            if (value) {
                const reg = new RegExp(doc.validation[field]);

                if (!reg.test(value)) {
                    if (field === 'number') {
                        errors[field] = getErrorsDocumentNumberText(valueType);
                    } else {
                        errors[field] = getErrorsFieldText(field);
                    }
                }
            }
        }
    });

    return errors;
};

export default validateForm;
