import * as i18nBlock from 'i18n/accountForms';

import {EDocumentType} from 'server/api/TravelersApi/enums/EDocumentType';

export default function getErrorsDocumentNumberText(
    type: EDocumentType,
): string {
    switch (type) {
        case EDocumentType.RU_BIRTH_CERTIFICATE:
            return i18nBlock.errorsDotRuBirthCertificateDotNumber();
        case EDocumentType.RU_FOREIGN_PASSPORT:
            return i18nBlock.errorsDotRuForeignPassportDotNumber();
        case EDocumentType.RU_MILITARY_ID:
            return i18nBlock.errorsDotRuMilitaryIdDotNumber();
        case EDocumentType.RU_NATIONAL_PASSPORT:
            return i18nBlock.errorsDotRuNationalPassportDotNumber();
        case EDocumentType.RU_SEAMAN_PASSPORT:
            return i18nBlock.errorsDotRuSeamanPassportDotNumber();
        case EDocumentType.OTHER:
            return '';
    }
}
