import * as i18nBlock from 'i18n/accountForms';

export default function getErrorsRequiredText(field: string): string {
    switch (field) {
        case 'birthDate':
            return i18nBlock.errorsDotRequiredDotBirthDate();
        case 'gender':
            return i18nBlock.errorsDotRequiredDotGender();
        case 'citizenship':
            return i18nBlock.errorsDotRequiredDotCitizenship();
        case 'title':
            return i18nBlock.errorsDotRequiredDotTitle();
        case 'type':
            return i18nBlock.errorsDotRequiredDotType();
        case 'number':
            return i18nBlock.errorsDotRequiredDotNumber();
        case 'cardName':
            return i18nBlock.errorsDotRequiredDotCardName();
        case 'cardNumber':
            return i18nBlock.errorsDotRequiredDotCardNumber();
        case 'firstName':
            return i18nBlock.errorsDotRequiredDotFirstName();
        case 'lastName':
            return i18nBlock.errorsDotRequiredDotLastName();
        default:
            return '';
    }
}
