import {
    IEditFormValuesProps,
    IErrorsProps,
} from 'projects/account/pages/Passengers/types';

import {isDateInFuture, isValidDateForBackend} from 'utilities/dateUtils/index';
import {isValidItn} from 'utilities/validation/isValidItn';
import {isRussianPhoneNumberStartsWithPlus} from 'projects/trains/lib/order/fields/phone';
import isImEmail from 'projects/account/pages/Passengers/utilities/validateForm/isImEmail';

import * as i18nBlock from 'i18n/accountForms';

export default (values: IEditFormValuesProps = {}): {errors: IErrorsProps} => {
    const errors: IErrorsProps = {};

    if (!values.title) {
        errors.title = i18nBlock.errorsDotRequiredDotTitle();
    }

    if (!values.gender) {
        errors.gender = i18nBlock.errorsDotRequiredDotGender();
    }

    if (values.birthDate) {
        if (!isValidDateForBackend(values.birthDate)) {
            errors.birthDate = i18nBlock.errorsDotBirthDateDotWrong();
        } else if (isDateInFuture(values.birthDate)) {
            errors.birthDate = i18nBlock.errorsDotBirthDateDotFuture();
        }
    } else {
        errors.birthDate = i18nBlock.errorsDotRequiredDotBirthDate();
    }

    if (values.itn && !isValidItn(values.itn)) {
        errors.itn = i18nBlock.errorsDotItnDotWrong();
    }

    if (values.email && !isImEmail(values.email)) {
        errors.email = i18nBlock.errorsDotEmailDotWrong();
    }

    if (values.phone && !isRussianPhoneNumberStartsWithPlus(values.phone)) {
        errors.phone = i18nBlock.errorsDotPhoneDotWrong();
    }

    if (
        !(errors.email || errors.phone) &&
        values.train_notifications_enabled &&
        !values.email &&
        !values.phone
    ) {
        errors.email = errors.phone = i18nBlock.errorsDotAgreeDotWrong();
    }

    return {
        errors,
    };
};
