import {Meta} from '@storybook/react/types-6-0';

import {TStorybookFunctionComponent} from 'storybook/types';

import {CurrencyType} from 'utilities/currency/CurrencyType';

import Activity from './Activity';

export default {
    title: 'Trips/Activity',
    component: Activity,
} as Meta;

export const Simple: TStorybookFunctionComponent = () => (
    <div style={{maxWidth: 400}}>
        <Activity
            imageSrc="https://avatars.mdst.yandex.net/get-afishanew/749/b8a007948e97ae7203ebcaa1f7c066c3/s540x270"
            title="King’s Man: Начало"
            label="Афиша"
            description="Кино"
            price={{
                value: 150,
                currency: CurrencyType.RUB,
            }}
            date="9 фев"
            url="https://afisha.tst.yandex.ru/saint-petersburg/cinema/kings-man-nachalo?schedule-date=2022-02-09"
            onClick={(): void => console.log('clicked')}
        />
    </div>
);
