import ETripActivityType from 'types/trips/ITripActivities/ETripActivityType';

import getActivityTypeText from '../../../utilities/getActivityTypeText';

export interface IFilterItem {
    key: string;
    text: string;
    value: ETripActivityType | null;
}

export default function getFilterItems(
    available: ETripActivityType[],
): IFilterItem[] {
    if (available.length < 2) {
        return [];
    }

    return [null, ETripActivityType.AFISHA, ETripActivityType.IZI_TRAVEL]
        .filter(item => {
            return item === null || available.includes(item);
        })
        .map(item => ({
            key: String(item),
            text: getActivityTypeText(item),
            value: item,
        }));
}
