import {useMemo, useState} from 'react';
import uniq from 'lodash/uniq';

import ETripActivityType from 'types/trips/ITripActivities/ETripActivityType';
import TTripActivity from 'types/trips/ITripActivities/TTripActivity';

interface IActivityTypeFilters {
    active: ETripActivityType | null;
    setActive(active: ETripActivityType | null): void;
    available: ETripActivityType[];
    filtered: TTripActivity[];
}

export default function useActivityTypeFilter(
    activities: TTripActivity[],
): IActivityTypeFilters {
    const [active, setActive] = useState<ETripActivityType | null>(null);
    const available = useMemo(() => {
        return uniq(activities.map(activity => activity.type));
    }, [activities]);
    const filtered = useMemo(() => {
        if (active === null) {
            return activities;
        }

        return activities.filter(activity => {
            return activity.type === active;
        });
    }, [active, activities]);

    return useMemo(
        () => ({
            active,
            setActive,
            available,
            filtered,
        }),
        [active, available, filtered],
    );
}
