import TTripActivity from 'types/trips/ITripActivities/TTripActivity';
import ETripActivityType from 'types/trips/ITripActivities/ETripActivityType';

import getLocalizedTourType from 'utilities/iziTravel/getLocalizedTourType';
import {formatDurationTime} from 'utilities/dateUtils/formatDurationTime/formatDurationTime';

import {IActivityProps} from 'projects/account/pages/TripPage/components/ActivitiesBlock/components/Activity/Activity';

import getActivityTypeText from './getActivityTypeText';

export default function prepareActivityProps(
    activity: TTripActivity,
): IActivityProps | null {
    const label = getActivityTypeText(activity.type);

    if (activity.type === ETripActivityType.AFISHA) {
        const event = activity.payload;

        return {
            imageSrc: event.imageUrl,
            title: event.name,
            description: event.type,
            label,
            price: event.minPrice,
            date: event.dateText,
            url: event.eventUrl,
        };
    }

    if (activity.type === ETripActivityType.IZI_TRAVEL) {
        const tour = activity.payload;

        return {
            imageSrc: tour.imageUrl,
            title: tour.name,
            description: getLocalizedTourType(tour),
            label,
            date: tour.duration
                ? formatDurationTime(tour.duration, {precision: 'minutes'})
                : null,
            url: tour.tourUrl,
        };
    }

    return null;
}
