import {Meta} from '@storybook/react/types-6-0';

import {TStorybookFunctionComponent} from 'storybook/types';
import {IAirline} from 'types/trips/ITripAviaOrder';

import StyleguidistSizeTable, {
    ISizeDescription,
} from 'components/StyleguidistSizeTable/StyleguidistSizeTable';

import mockAirlines from 'server/api/TripsApi/__mocks__/mockAirlines';

import AirlinesLogo, {IAirlinesLogoProps} from './AirlinesLogo';

export default {
    title: 'Trips/AirlinesLogo',
    component: AirlinesLogo,
} as Meta;

const sizes: Pick<ISizeDescription, 'name' | 'size' | 'comment'>[] = [
    {
        name: 'x-small',
        size: '36px',
    },
    {
        name: 'small',
        size: '62px',
    },
    {
        name: 'big',
        size: '80px',
    },
];

interface ILayoutProps {
    airlines: IAirline[];
}

const Layout: React.FC<ILayoutProps> = props => (
    <StyleguidistSizeTable
        sizes={sizes.map(({name, size, comment}) => ({
            name: name,
            size: size,
            comment: comment,
            example: (
                <AirlinesLogo
                    size={name as IAirlinesLogoProps['size']}
                    airlines={props.airlines}
                />
            ),
        }))}
    />
);

export const Simple: TStorybookFunctionComponent = () => (
    <Layout airlines={[mockAirlines.aeroflot]} />
);

export const TwoAirlines: TStorybookFunctionComponent = () => (
    <Layout airlines={[mockAirlines.aeroflot, mockAirlines.pobeda]} />
);

export const ThreeAirlines: TStorybookFunctionComponent = () => (
    <Layout
        airlines={[
            mockAirlines.aeroflot,
            mockAirlines.pobeda,
            mockAirlines.uralAirlines,
        ]}
    />
);

export const EmptyAirlines: TStorybookFunctionComponent = () => (
    <Layout airlines={[]} />
);
