import React from 'react';

import {IAirline} from 'types/trips/ITripAviaOrder';
import {IWithClassName} from 'types/withClassName';

import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';

import FlightIcon from 'icons/24/Flight';

import cx from './AirlinesLogo.scss';

export interface IAirlinesLogoProps extends IWithClassName, IWithQaAttributes {
    isCancelled?: boolean;
    airlines: IAirline[];
    /**
     * Размер лого
     */
    size: 'x-small' | 'small' | 'big';
}

const AirlinesLogo: React.FC<IAirlinesLogoProps> = props => {
    const {className, airlines, size, isCancelled = false} = props;
    const isStub = airlines.length === 0 || airlines.length > 2;

    return (
        <div
            className={cx(
                'root',
                `root_size_${size}`,
                {
                    root_oneLogo: airlines.length === 1,
                    root_twoLogos: airlines.length === 2,
                    root_stub: isStub,
                    root_cancelled: isCancelled,
                },
                className,
            )}
            style={{width: size, height: size}}
            {...prepareQaAttributes(props)}
        >
            {isStub ? (
                <FlightIcon className={cx('stubIcon')} />
            ) : (
                airlines.map((airline, index) => {
                    return (
                        <div
                            key={index}
                            className={cx('logoContainer', {
                                logoContainer_withBackground: Boolean(
                                    airline.color,
                                ),
                            })}
                            style={{
                                backgroundColor: airline.color,
                            }}
                            {...prepareQaAttributes({
                                parent: props,
                                current: 'airline',
                                key: index,
                            })}
                        >
                            <img
                                className={cx('logo')}
                                src={airline.logo}
                                alt={airline.title}
                            />
                        </div>
                    );
                })
            )}
        </div>
    );
};

export default React.memo(AirlinesLogo);
